<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Api\Data;

interface LoginAttributeCustomerValueInterface
{
    public const VALUE_ID = 'value_id';
    public const ATTRIBUTE_ID = 'attribute_id';
    public const CUSTOMER_ID = 'customer_id';
    public const VALUE = 'value';

    /**
     * @return int
     */
    public function getValueId(): int;

    /**
     * @param int $id
     * @return void
     */
    public function setValueId(int $id): void;

    /**
     * @return int
     */
    public function getAttributeId(): int;

    /**
     * @param int $attributeId
     * @return void
     */
    public function setAttributeId(int $attributeId): void;

    /**
     * @return int
     */
    public function getCustomerId(): int;

    /**
     * @param int $customerId
     * @return void
     */
    public function setCustomerId(int $customerId): void;

    /**
     * @return string
     */
    public function getValue(): string;

    /**
     * @param string $value
     * @return void
     */
    public function setValue(string $value): void;
}
