<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Login as Customer for Magento 2
*/
declare(strict_types=1);

namespace Amasty\CustomerLogin\Setup;

use Amasty\CustomerLogin\Model\ResourceModel\LoggedIn;
use Amasty\CustomerLogin\Model\ResourceModel\LoggedInOrder;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    public const TABLE_NAMES = [
        LoggedIn::TABLE_NAME,
        LoggedInOrder::TABLE_NAME
    ];

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $this->removeTableAndConfig($setup);
    }

    /**
     * @param SchemaSetupInterface $setup
     */
    private function removeTableAndConfig(SchemaSetupInterface $setup)
    {
        $setup->startSetup();
        $defaultConnection = $setup->getConnection(ResourceConnection::DEFAULT_CONNECTION);
        foreach (self::TABLE_NAMES as $tableName) {
            $defaultConnection->dropTable($setup->getTable($tableName));
        }
        $setup->endSetup();

        $defaultConnection->delete(
            $setup->getTable('core_config_data'),
            "`path` LIKE 'amcustomerlogin/%'"
        );
    }
}
