<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Login as Customer for Magento 2
*/

declare(strict_types=1);

namespace Amasty\CustomerLogin\Plugin\Sales\Model;

use Magento\Customer\Model\Session;
use Magento\Sales\Model\Order;
use Magento\User\Api\Data\UserInterfaceFactory;
use Magento\User\Model\ResourceModel\User;

class AddCommentToOrderPlugin
{
    /**
     * @var Session
     */
    private $customerSession;

    /**
     * @var UserInterfaceFactory
     */
    private $userFactory;

    /**
     * @var User
     */
    private $userResource;

    public function __construct(
        Session $customerSession,
        UserInterfaceFactory $userFactory,
        User $userResource
    ) {
        $this->customerSession = $customerSession;
        $this->userFactory = $userFactory;
        $this->userResource = $userResource;
    }

    public function afterPlace(Order $subject, Order $result): Order
    {
        if ($adminId = (int)$this->customerSession->getAmCustomerLoginAdminId()) {
            $admin = $this->userFactory->create();
            $this->userResource->load($admin, $adminId);
            if ($admin->getId()) {
                $adminUsername = $admin->getUserName();
                $subject->addCommentToStatusHistory(
                    'Order was created by admin (' . $adminUsername . ') using Login as Customer',
                    false,
                    true
                );
            }
        }

        return $result;
    }
}
