<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Login as Customer for Magento 2
*/

declare(strict_types=1);

namespace Amasty\CustomerLogin\Observer;

use Amasty\CustomerLogin\Model\LoggedInOrder as LoggedInOrderModel;
use Amasty\CustomerLogin\Model\LoggedInOrderFactory;
use Amasty\CustomerLogin\Model\ResourceModel\LoggedInOrder as LoggedInOrderResource;
use Magento\Customer\Model\Session;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;

class PlaceOrder implements ObserverInterface
{
    /**
     * @var array
     */
    protected $orderIds = [];

    /**
     * @var LoggedInOrderFactory
     */
    private $loggedInOrderFactory;

    /**
     * @var LoggedInOrderResource
     */
    private $loggedInOrderResource;

    /**
     * @var Session
     */
    private $customerSession;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        LoggedInOrderFactory $loggedInOrderFactory,
        LoggedInOrderResource $loggedInOrderResource,
        Session $customerSession,
        LoggerInterface $logger
    ) {
        $this->loggedInOrderFactory = $loggedInOrderFactory;
        $this->loggedInOrderResource = $loggedInOrderResource;
        $this->customerSession = $customerSession;
        $this->logger = $logger;
    }

    public function execute(Observer $observer)
    {
        $orderId = (int)$observer->getEvent()->getOrder()->getId();
        $adminId = (int)$this->customerSession->getAmCustomerLoginAdminId();
        if ($orderId && $adminId && !in_array($orderId, $this->orderIds)) {
            /** @var \Amasty\CustomerLogin\Model\LoggedInOrder $loggedInOrder */
            $loggedInOrder = $this->loggedInOrderFactory->create();
            $loggedInOrder->setData(LoggedInOrderModel::ORDER_ID, $orderId)
                ->setData(LoggedInOrderModel::ADMIN_ID, $adminId);

            try {
                $this->loggedInOrderResource->save($loggedInOrder);
                $this->orderIds[] = $orderId;
            } catch (\Exception $e) {
                $this->logger->critical($e);
            }
        }
    }
}
