<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Login as Customer for Magento 2
*/

declare(strict_types=1);

namespace Amasty\CustomerLogin\Model\ResourceModel\Order\Grid;

use Magento\Sales\Model\ResourceModel\Order\Grid\Collection as OrderGridCollection;
use Amasty\CustomerLogin\Model\ResourceModel\LoggedInOrder;

class Collection extends OrderGridCollection
{
    protected function _renderFiltersBefore()
    {
        $this->getSelect()->joinLeft(
            ['customer_login_order_table' => $this->getTable(LoggedInOrder::TABLE_NAME)],
            'main_table.entity_id = customer_login_order_table.order_id',
            ['order_admin_id' => 'admin_id']
        )->joinLeft(
            ['admin_user' => $this->getTable('admin_user')],
            'admin_user.user_id = customer_login_order_table.admin_id',
            ['amasty_customer_login_username' => 'username']
        );
        parent::_renderFiltersBefore();
    }

    public function addFieldToFilter($field, $condition = null)
    {
        if ($field == 'amasty_customer_login_username') {
            $field = 'username';
        }

        return parent::addFieldToFilter($field, $condition);
    }
}
