<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Login as Customer for Magento 2
*/

declare(strict_types=1);

namespace Amasty\CustomerLogin\Model;

use Amasty\CustomerLogin\Api\Data\LoggedInInterface;
use Magento\Framework\Model\AbstractModel;

class LoggedIn extends AbstractModel implements LoggedInInterface
{
    public function _construct()
    {
        parent::_construct();
        $this->_init(\Amasty\CustomerLogin\Model\ResourceModel\LoggedIn::class);
        $this->setIdFieldName(LoggedInInterface::LOGGEDIN_ID);
    }

    /**
     * @return int
     */
    public function getLoggedInId(): int
    {
        return (int)$this->_getData(LoggedInInterface::LOGGEDIN_ID);
    }

    /**
     * @param int $loggedInId
     *
     * @return LoggedInInterface
     */
    public function setLoggedInId(int $loggedInId): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::LOGGEDIN_ID, $loggedInId);
    }

    /**
     * @return string
     */
    public function getLoggedInTime(): string
    {
        return (string)$this->_getData(LoggedInInterface::LOGGEDIN_TIME);
    }

    /**
     * @param string $time
     *
     * @return LoggedInInterface
     */
    public function setLoggedInTime(string $time): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::LOGGEDIN_TIME, $time);
    }

    /**
     * @return int
     */
    public function getAdminId(): int
    {
        return (int)$this->_getData(LoggedInInterface::ADMIN_ID);
    }

    /**
     * @param int $adminId
     *
     * @return LoggedInInterface
     */
    public function setAdminId(int $adminId): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::ADMIN_ID, $adminId);
    }

    /**
     * @return int
     */
    public function getCustomerId(): int
    {
        return (int)$this->_getData(LoggedInInterface::CUSTOMER_ID);
    }

    /**
     * @param int $customerId
     *
     * @return LoggedInInterface
     */
    public function setCustomerId(int $customerId): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::CUSTOMER_ID, $customerId);
    }

    /**
     * @return string
     */
    public function getAdminUsername(): string
    {
        return (string)$this->_getData(LoggedInInterface::ADMIN_USERNAME);
    }

    /**
     * @param string $adminUsername
     *
     * @return LoggedInInterface
     */
    public function setAdminUsername(string $adminUsername): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::ADMIN_USERNAME, $adminUsername);
    }

    /**
     * @return string
     */
    public function getAdminEmail(): string
    {
        return (string)$this->_getData(LoggedInInterface::ADMIN_EMAIL);
    }

    /**
     * @param string $adminEmail
     *
     * @return LoggedInInterface
     */
    public function setAdminEmail(string $adminEmail): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::ADMIN_EMAIL, $adminEmail);
    }

    /**
     * @return string
     */
    public function getCustomerName(): string
    {
        return (string)$this->_getData(LoggedInInterface::CUSTOMER_NAME);
    }

    /**
     * @param string $customerName
     *
     * @return LoggedInInterface
     */
    public function setCustomerName(string $customerName): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::CUSTOMER_NAME, $customerName);
    }

    /**
     * @return string
     */
    public function getCustomerLastName(): string
    {
        return (string)$this->_getData(LoggedInInterface::CUSTOMER_LASTNAME);
    }

    /**
     * @param string $customerLastName
     *
     * @return LoggedInInterface
     */
    public function setCustomerLastName(string $customerLastName): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::CUSTOMER_LASTNAME, $customerLastName);
    }

    /**
     * @return string
     */
    public function getCustomerEmail(): string
    {
        return (string)$this->_getData(LoggedInInterface::CUSTOMER_EMAIL);
    }

    /**
     * @param string $customerEmail
     *
     * @return LoggedInInterface
     */
    public function setCustomerEmail(string $customerEmail): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::CUSTOMER_EMAIL, $customerEmail);
    }

    /**
     * @return int
     */
    public function getWebsiteId(): int
    {
        return (int)$this->_getData(LoggedInInterface::WEBSITE_ID);
    }

    /**
     * @param int $websiteId
     *
     * @return LoggedInInterface
     */
    public function setWebsiteId(int $websiteId): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::WEBSITE_ID, $websiteId);
    }

    /**
     * @return string
     */
    public function getWebsiteCode(): string
    {
        return (string)$this->_getData(LoggedInInterface::WEBSITE_CODE);
    }

    /**
     * @param string $websiteCode
     *
     * @return LoggedInInterface
     */
    public function setWebsiteCode(string $websiteCode): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::WEBSITE_CODE, $websiteCode);
    }

    /**
     * @return string
     */
    public function getSecretKey(): string
    {
        return (string)$this->_getData(LoggedInInterface::SECRET_KEY);
    }

    /**
     * @param string $secretKey
     *
     * @return LoggedInInterface
     */
    public function setSecretKey(string $secretKey): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::SECRET_KEY, $secretKey);
    }

    /**
     * @return int
     */
    public function getStoreId(): int
    {
        return (int)$this->_getData(LoggedInInterface::STORE_ID);
    }

    /**
     * @param int $storeId
     *
     * @return LoggedInInterface
     */
    public function setStoreId(int $storeId): LoggedInInterface
    {
        return $this->setData(LoggedInInterface::STORE_ID, $storeId);
    }
}
