<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Login as Customer for Magento 2
*/

namespace Amasty\CustomerLogin\Model;

use Magento\Customer\Model\ResourceModel\CustomerRepository;
use Magento\Integration\Model\Oauth\TokenFactory;

class CustomerToken implements \Amasty\CustomerLogin\Api\CustomerTokenInterface
{
    /**
     * @var TokenFactory
     */
    private $tokenFactory;

    /**
     * @var CustomerRepository
     */
    private $customerRepository;

    public function __construct(
        TokenFactory $tokenFactory,
        CustomerRepository $customerRepository
    ) {
        $this->tokenFactory = $tokenFactory;
        $this->customerRepository = $customerRepository;
    }

    /**
     * @inheritdoc
     */
    public function createCustomerToken($customerId)
    {
        /** TODO log */
        $customer = $this->customerRepository->getById($customerId);
        return $this->tokenFactory->create()->createCustomerToken($customer->getId())->getToken();
    }
}
