<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Login as Customer for Magento 2
*/

declare(strict_types=1);

namespace Amasty\CustomerLogin\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * @var string
     */
    protected $pathPrefix = 'amcustomerlogin/';

    public const NEW_TAB = 'general/new_tab';
    public const ALLOW_SELECT_STORE = 'general/allow_select_store';

    /**
     * @return bool
     */
    public function isNewTab(): bool
    {
        return $this->isSetFlag(self::NEW_TAB);
    }

    /**
     * @return bool
     */
    public function isAllowSelectStore(): bool
    {
        return $this->isSetFlag(self::ALLOW_SELECT_STORE);
    }
}
