<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Login as Customer for Magento 2
*/

declare(strict_types=1);

namespace Amasty\CustomerLogin\Api\Data;

interface LoggedInInterface
{
    public const LOGGEDIN_ID = 'logged_in_id';
    public const LOGGEDIN_TIME = 'logged_in_time';
    public const ADMIN_ID = 'admin_id';
    public const ADMIN_USERNAME = 'admin_username';
    public const ADMIN_EMAIL = 'admin_email';
    public const CUSTOMER_ID = 'customer_id';
    public const CUSTOMER_NAME = 'customer_name';
    public const CUSTOMER_LASTNAME = 'customer_lastname';
    public const CUSTOMER_EMAIL = 'customer_email';
    public const WEBSITE_ID = 'website_id';
    public const WEBSITE_CODE = 'website_code';
    public const SECRET_KEY = 'secret_key';
    public const STORE_ID = 'store_id';

    /**
     * @return int
     */
    public function getLoggedInId(): int;

    /**
     * @param int $loggedInId
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setLoggedInId(int $loggedInId): LoggedInInterface;

    /**
     * string $time
     *
     * @return string
     */
    public function setLoggedInTime(string $time): LoggedInInterface;

    /**
     * @return string
     */
    public function getLoggedInTime(): string;

    /**
     * @return int
     */
    public function getAdminId(): int;

    /**
     * @param int $adminId
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setAdminId(int $adminId): LoggedInInterface;

    /**
     * @return string
     */
    public function getAdminUsername(): string;

    /**
     * @param string $adminUsername
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setAdminUsername(string $adminUsername): LoggedInInterface;

    /**
     * @return string
     */
    public function getAdminEmail(): string;

    /**
     * @param string $adminEmail
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setAdminEmail(string $adminEmail): LoggedInInterface;

    /**
     * @return int
     */
    public function getCustomerId(): int;

    /**
     * @param int $customerId
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setCustomerId(int $customerId): LoggedInInterface;

    /**
     * @return string
     */
    public function getCustomerName(): string;

    /**
     * @param string $customerName
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setCustomerName(string $customerName): LoggedInInterface;

    /**
     * @return string
     */
    public function getCustomerLastName(): string;

    /**
     * @param string $customerLastName
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setCustomerLastName(string $customerLastName): LoggedInInterface;

    /**
     * @return string
     */
    public function getCustomerEmail(): string;

    /**
     * @param string $customerEmail
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setCustomerEmail(string $customerEmail): LoggedInInterface;

    /**
     * @return int
     */
    public function getWebsiteId(): int;

    /**
     * @param int $websiteId
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setWebsiteId(int $websiteId): LoggedInInterface;

    /**
     * @return string
     */
    public function getWebsiteCode(): string;

    /**
     * @param string $websiteCode
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setWebsiteCode(string $websiteCode): LoggedInInterface;

    /**
     * @return string
     */
    public function getSecretKey(): string;

    /**
     * @param string $secretKey
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setSecretKey(string $secretKey): LoggedInInterface;

    /**
     * @return int
     */
    public function getStoreId(): int;

    /**
     * @param int $storeId
     *
     * @return \Amasty\CustomerLogin\Api\Data\LoggedInInterface
     */
    public function setStoreId(int $storeId): LoggedInInterface;
}
