<?php
declare(strict_types=1);

namespace Amasty\CustomerImportEntity\Import\DataHandling\RowModifier\Customer;

use Amasty\ImportCore\Api\Modifier\RowModifierInterface;

class Address implements RowModifierInterface
{
    /**
     * @var RegionConverter
     */
    private $regionConverter;

    public function __construct(
        RegionConverter $regionConverter
    ) {
        $this->regionConverter = $regionConverter;
    }

    /**
     * @inheritDoc
     */
    public function transform(array &$row): array
    {
        return $this->regionConverter->executeRow($row);
    }
}
