<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */

namespace Amasty\CustomerAttributesHyvaCompatibility\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Framework\Locale\Bundle\DataBundle;
use Magento\Framework\Locale\ResolverInterface;

/**
 * ViewModel to retrieve calendar config
 */
class Calendar implements ArgumentInterface
{
    /**
     * @var ResolverInterface
     */
    private ResolverInterface $localeResolver;

    /**
     * @var DataBundle
     */
    private DataBundle $dataBundle;

    /**
     * @var SerializerInterface
     */
    private SerializerInterface $serializer;

    /**
     * @param SerializerInterface $serializer
     * @param DataBundle $dataBundle
     * @param ResolverInterface $localeResolver
     */
    public function __construct(
        SerializerInterface $serializer,
        DataBundle $dataBundle,
        ResolverInterface $localeResolver
    ) {
        $this->serializer = $serializer;
        $this->dataBundle = $dataBundle;
        $this->localeResolver = $localeResolver;
    }

    /**
     * Get translated calendar config json formatted
     *
     * @return string
     */
    public function getTranslatedCalendarConfigJson(): string
    {
        $localeData = (new DataBundle())->get($this->localeResolver->getLocale());
        $monthsData = $localeData['calendar']['gregorian']['monthNames'];
        $daysData = $localeData['calendar']['gregorian']['dayNames'];

        return $this->serializer->serialize(
            [
                'closeText' => __('Done'),
                'prevText' => __('Prev'),
                'nextText' => __('Next'),
                'currentText' => __('Today'),
                'monthNames' => array_values(iterator_to_array($monthsData['format']['wide'])),
                'monthNamesShort' => array_values(iterator_to_array($monthsData['format']['abbreviated'])),
                'dayNames' => array_values(iterator_to_array($daysData['format']['wide'])),
                'dayNamesShort' => array_values(iterator_to_array($daysData['format']['abbreviated'])),
                'dayNamesMin' => array_values(
                    iterator_to_array(($daysData['format']['short']) ?: $daysData['format']['abbreviated'])
                ),
            ]
        );
    }
}
