<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */

namespace Amasty\CustomerAttributesHyvaCompatibility\Plugin\Form\Element;

use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\Data\Form\Element\Date;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\LayoutInterface;

/**
 * Plugin to change element html for date type
 */
class DatePlugin
{
    private const TEMPLATE = 'Amasty_CustomerAttributesHyvaCompatibility::widget/form/renderer/element/date.phtml';

    /**
     * @var LayoutInterface
     */
    private LayoutInterface $layout;

    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @param LayoutInterface $layout
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        LayoutInterface $layout,
        CurrentTheme $currentTheme
    ) {
        $this->layout = $layout;
        $this->currentTheme = $currentTheme;
    }

    /**
     * Add custom template for date element
     *
     * @param Date $subject
     * @param string $result
     * @return string
     */
    public function afterGetElementHtml(
        Date $subject,
        string $result
    ): string {
        if (!$this->currentTheme->isHyva()) {
            return $result;
        }

        return $this->layout
            ->createBlock(Template::class)
            ->setElement($subject)
            ->setTemplate(self::TEMPLATE)
            ->toHtml();
    }
}
