<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */

namespace Amasty\CustomerAttributesHyvaCompatibility\Plugin\Customer\Model\Metadata\Form;

use Magento\Customer\Model\Metadata\Form\AbstractData as AbstractDataOriginal;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Exception\LocalizedException;

class AbstractData
{
    /**
     * Check if attribute is a custom and value wasn't proceed from form (attribute is hidden)
     * then set old value to fix attribute value removing.
     * Change date attribute to fix bugs with different date formats
     *
     * @param AbstractDataOriginal $subject
     * @param array|string $value
     * @return array|string
     * @throws LocalizedException
     */
    public function afterExtractValue($subject, $value)
    {
        /** @var \Magento\Customer\Model\Data\AttributeMetadata $attribute */
        $attribute = $subject->getAttribute();
        if ($attribute->getBackendType() === Table::TYPE_DATETIME && $attribute->isUserDefined() && is_string($value)) {
            return (new \DateTime($value))->getTimestamp();
        }

        return $value;
    }
}
