<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */

namespace Amasty\CustomerAttributesHyvaCompatibility\Block\Widget\Form\Renderer;

use Amasty\CustomerAttributes\Block\Widget\Form\Renderer\Element as ElementOriginal;
use Amasty\CustomerAttributes\Model\Validation;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * Override of the original widget renderer
 */
class Element extends ElementOriginal
{
    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @param Context $context
     * @param CurrentTheme $currentTheme
     * @param Validation $validation
     * @param array $data
     */
    public function __construct(Context $context, CurrentTheme $currentTheme, Validation $validation, array $data = [])
    {
        parent::__construct($context, $validation, $data);
        $this->currentTheme = $currentTheme;
    }

    /**
     * Render HTML
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    public function render(AbstractElement $element): string
    {
        if (!$this->currentTheme->isHyva()) {
            return parent::render($element);
        }

        //Skip "validation js" html that is added by the original method
        $this->_element = $element;
        return $this->toHtml();
    }
}
