<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */

namespace Amasty\CustomerAttributesHyvaCompatibility\Block\Data\Form\Element;

use Amasty\CustomerAttributes\Block\Data\Form\Element\Selectimg as OriginalSelectimg;
use Amasty\CustomerAttributes\Helper\Image;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\Data\Form\Element\CollectionFactory;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\Escaper;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\LayoutInterface;

class SingleRadioImg extends OriginalSelectimg
{
    // phpcs:disable Generic.Files.LineLength.TooLong
    private const TEMPLATE = 'Amasty_CustomerAttributesHyvaCompatibility::widget/form/renderer/element/single-radio-img.phtml';

    /**
     * @var LayoutInterface
     */
    private LayoutInterface $layout;

    /**
     * @var Image
     */
    private Image $imageHelper;

    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @param Factory $factoryElement
     * @param CollectionFactory $factoryCollection
     * @param Escaper $escaper
     * @param array $data
     * @param Image $imageHelper
     * @param LayoutInterface $layout
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        Factory $factoryElement,
        CollectionFactory $factoryCollection,
        Escaper $escaper,
        array $data,
        Image $imageHelper,
        LayoutInterface $layout,
        CurrentTheme $currentTheme
    ) {
        parent::__construct($factoryElement, $factoryCollection, $escaper, $data, $imageHelper);
        $this->layout = $layout;
        $this->imageHelper = $imageHelper;
        $this->currentTheme = $currentTheme;
    }

    /**
     * @inheritDoc
     */
    public function getElementHtml()
    {
        if (!$this->currentTheme->isHyva()) {
            return parent::getElementHtml();
        }

        $html = $this->layout->createBlock(Template::class)
            ->setTemplate(self::TEMPLATE)
            ->setElement($this)
            ->toHtml();

        $html .= $this->getAfterElementHtml();
        return $html;
    }

    /**
     * Icon for element
     *
     * @param string $optionValue
     * @return string
     */
    public function getIcon(string $optionValue): string
    {
        return $this->imageHelper->getIconUrl($optionValue);
    }
}
