<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */
namespace Amasty\CustomerAttributesHyvaCompatibility\Block\Data\Form\Element;

use Amasty\CustomerAttributes\Block\Data\Form\Element\Multiselect as MultiselectOriginal;

class Multiselect extends MultiselectOriginal
{
    /**
     * Get Element Html
     *
     * @return string
     */
    public function getElementHtml()
    {
        if ($this->getRequired()) {
            $this->addCustomAttribute('required', 'required');
        }

        $this->addClass('form-multiselect');

        return parent::getElementHtml();
    }
}
