<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */

namespace Amasty\CustomerAttributesHyvaCompatibility\Block\Data\Form\Element;

use Amasty\CustomerAttributes\Block\Data\Form\Element\Multiselectimg as MultiselectimgOriginal;
use Amasty\CustomerAttributes\Helper\Image;
use Magento\Framework\Data\Form\Element\CollectionFactory;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\Escaper;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\LayoutInterface;
use Hyva\Theme\Service\CurrentTheme;

/**
 * Override multiselectimg element to add custom template
 */
class MultiSelectImg extends MultiselectimgOriginal
{
    // phpcs:disable Generic.Files.LineLength.TooLong
    private const TEMPLATE = 'Amasty_CustomerAttributesHyvaCompatibility::widget/form/renderer/element/multiselect-img-option.phtml';

    /**
     * @var Image
     */
    private Image $imageHelper;

    /**
     * @var LayoutInterface
     */
    private LayoutInterface $layout;

    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @param Factory $factoryElement
     * @param CollectionFactory $factoryCollection
     * @param Escaper $escaper
     * @param array $data
     * @param Image $imageHelper
     * @param LayoutInterface $layout
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        Factory $factoryElement,
        CollectionFactory $factoryCollection,
        Escaper $escaper,
        array $data,
        Image $imageHelper,
        LayoutInterface $layout,
        CurrentTheme $currentTheme
    ) {
        parent::__construct($factoryElement, $factoryCollection, $escaper, $data, $imageHelper);
        $this->imageHelper = $imageHelper;
        $this->layout = $layout;
        $this->currentTheme = $currentTheme;
    }

    /**
     * Is it checked
     *
     * @param mixed $value
     * @return string
     */
    public function isChecked($value): string
    {
        $checked = $this->getValue() ?: $this->getData('checked');
        if (empty($checked)) {
            return '';
        }

        if (!is_array($checked)) {
            $checked = explode(',', $checked);
        }

        foreach ($checked as $k => $v) {
            $checked[$k] = (string)($v);
        }

        return in_array((string)$value, $checked) ? 'checked' : '';
    }

    /**
     * Render option html with random template
     *
     * @param array $option
     * @return string
     */
    protected function _optionToHtml($option): string
    {
        if (!$this->currentTheme->isHyva()) {
            return parent::_optionToHtml($option);
        }

        $this->_prepareValues();
        $icon = $this->imageHelper->getIconUrl($option['value']);
        return $this->layout->createBlock(Template::class)
            ->setTemplate(self::TEMPLATE)
            ->setOption($option)
            ->setElement($this)
            ->setValue($option['value'])
            ->setIcon($icon)
            ->toHtml();
    }
}
