<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */

namespace Amasty\CustomerAttributesHyvaCompatibility\Block\Data\Form\Element;

use Amasty\CustomerAttributes\Block\Data\Form\Element\File as FileOriginal;
use Magento\Backend\Helper\Data;
use Magento\Customer\Model\Session;
use Magento\Framework\Data\Form\Element\CollectionFactory;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\Escaper;
use Magento\Framework\Url\EncoderInterface;
use Magento\Framework\UrlFactory;
use Magento\Framework\View\Asset\Repository;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\LayoutInterface;
use Hyva\Theme\Service\CurrentTheme;

/**
 * Override file element to add custom template
 */
class File extends FileOriginal
{
    /**
     * @var LayoutInterface
     */
    private LayoutInterface $layout;

    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @param Factory $factoryElement
     * @param CollectionFactory $factoryCollection
     * @param Escaper $escaper
     * @param Data $adminhtmlData
     * @param Repository $assetRepo
     * @param EncoderInterface $urlEncoder
     * @param array $data
     * @param Session $customerSession
     * @param UrlFactory $urlFactory
     * @param LayoutInterface $layout
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        Factory $factoryElement,
        CollectionFactory $factoryCollection,
        Escaper $escaper,
        Data $adminhtmlData,
        Repository $assetRepo,
        EncoderInterface $urlEncoder,
        array $data,
        Session $customerSession,
        UrlFactory $urlFactory,
        LayoutInterface $layout,
        CurrentTheme $currentTheme
    ) {
        parent::__construct(
            $factoryElement,
            $factoryCollection,
            $escaper,
            $adminhtmlData,
            $assetRepo,
            $urlEncoder,
            $data,
            $customerSession,
            $urlFactory
        );

        $this->layout = $layout;
        $this->currentTheme = $currentTheme;
    }

    /**
     * Override template
     *
     * @return string
     */
    public function getElementHtml() : string
    {
        if (!$this->currentTheme->isHyva()) {
            return parent::getElementHtml();
        }

        return $this->layout
            ->createBlock(Template::class)
            ->setDownloadUrl($this->getValue() ? $this->_getPreviewUrl() : '')
            ->setElement($this)
            ->setTemplate('Amasty_CustomerAttributesHyvaCompatibility::widget/form/renderer/element/file.phtml')
            ->toHtml();
    }

    /**
     * Check if value is not empty
     *
     * @return bool
     */
    public function isFileExists() : bool
    {
        $value = $this->getValue();
        return $value && (
            !is_array($value)
                && strpos($value, ".") !== false
            );
    }
}
