<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Customer Attributes Hyva Compatibility
 */

namespace Amasty\CustomerAttributesHyvaCompatibility\Block\Customer\Form;

use Amasty\CustomerAttributes\Block\Customer\Form\Attributes as AmastyAttributes;
use Magento\Eav\Model\Entity\Attribute;
use Magento\Framework\Data\Form\Element\AbstractElement;

class Attributes extends AmastyAttributes
{
    /**
     * Add validation type based on validation css class
     *
     * @param string $inputType
     * @param AbstractElement $element
     * @param Attribute $attribute
     * @return void
     */
    protected function _applyTypeSpecificConfig(
        $inputType,
        $element,
        Attribute $attribute
    ): void {
        if ($class = $attribute->getFrontendClass()) {
            $validationType = str_replace('validate-', '', $class);
            $element->setValidationType($validationType);
        }

        parent::_applyTypeSpecificConfig($inputType, $element, $attribute);
    }

    /**
     * Fix template path
     *
     * @return Attributes
     */
    protected function _beforeToHtml()
    {
        $this->setTemplate('Amasty_CustomerAttributes::attributes.phtml');
        return parent::_beforeToHtml();
    }
}
