define([
    'jquery',
    'Magento_Ui/js/form/element/select',
    'uiRegistry'
], function ($, Select, uiRegistry) {
    'use strict';

    return Select.extend({
        UNSELECTED_VALUE: 0,

        initialize: function () {
            this._super();
            this.getParentComponent().elems.subscribe(function () {
                this.updateDependedFieldsVisibility();
            }.bind(this));
        },

        onUpdate: function () {
            this.updateDependedFieldsVisibility();
            this._super();
        },

        /**
         *
         * @return {Object}
         */
        getParentComponent: function () {
            return uiRegistry.get(this.parentName);
        },

        /**
         * Toggle visibility of dependent fields
         */
        updateDependedFieldsVisibility: function () {
            this.getParentComponent().elems().forEach(function (element) {
                if (element !== this) {
                    element.visible(+this.value() !== this.UNSELECTED_VALUE)
                }
            }.bind(this));
        }
    });
});
