<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Ui\DataProvider\Rule\Form\Modifier;

use Amasty\CustomStockStatusTimer\Api\Data\StockstatusTimerInformationInterface as StockstatusTimerInformation;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetByStockstatusRuleIdInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;

class CountdownTimer implements ModifierInterface
{
    /**
     * @var GetByStockstatusRuleIdInterface
     */
    private $getByStockstatusRuleId;

    public function __construct(
        GetByStockstatusRuleIdInterface $getByStockstatusRuleId
    ) {
        $this->getByStockstatusRuleId = $getByStockstatusRuleId;
    }

    public function modifyData(array $data)
    {
        foreach ($data as $ruleId => &$ruleData) {
            try {
                $countDownSettings = $this->getByStockstatusRuleId->execute((int)$ruleId);
                $ruleData['rule'][StockstatusTimerInformation::TIMER_POSITION] = $countDownSettings->getTimerPosition();
                $ruleData['rule'][StockstatusTimerInformation::TIMER_ID] = $countDownSettings->getTimerId();
            } catch (NoSuchEntityException $e) {
                null; // no action required
            }
        }

        return $data;
    }

    public function modifyMeta(array $meta)
    {
        return $meta;
    }
}
