<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Setup;

use Amasty\CustomStockStatusTimer\Api\Data\StockstatusTimerInformationInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    private $tablesToDrop = [
        StockstatusTimerInformationInterface::class
    ];

    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        foreach ($this->tablesToDrop as $tableName) {
            $tableName = $setup->getTable($tableName);

            if ($setup->tableExists($tableName)) {
                $setup->getConnection()->dropTable($tableName);
            }
        }

        $setup->endSetup();
    }
}
