<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Setup\Operation;

use Amasty\CustomStockStatusTimer\Api\Data\StockstatusTimerInformationInterface;
use Amasty\Stockstatus\Api\Data\RuleInterface;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\SchemaSetupInterface;

class CreateStockstatusTimerTable
{
    public function execute(SchemaSetupInterface $setup): void
    {
        $tableName = $setup->getTable(StockstatusTimerInformationInterface::MAIN_TABLE);
        $connection = $setup->getConnection();
        $table = $connection->newTable($tableName);
        $table->addColumn(
            StockstatusTimerInformationInterface::ID,
            Table::TYPE_SMALLINT,
            null,
            [
                Table::OPTION_IDENTITY => true,
                Table::OPTION_NULLABLE => false,
                Table::OPTION_PRIMARY => true,
                Table::OPTION_UNSIGNED => true
            ],
            'Stockstatus Timer Information id'
        );
        $table->addColumn(
            StockstatusTimerInformationInterface::STOCKSTATUS_RULE_ID,
            Table::TYPE_INTEGER,
            null,
            [
                Table::OPTION_NULLABLE => false,
                Table::OPTION_UNSIGNED => true
            ],
            'Stockstatus Rule link'
        );
        $table->addColumn(
            StockstatusTimerInformationInterface::TIMER_ID,
            Table::TYPE_INTEGER,
            null,
            [
                Table::OPTION_NULLABLE => false,
                Table::OPTION_UNSIGNED => true
            ],
            'Countdown Entity link'
        );
        $table->addColumn(
            StockstatusTimerInformationInterface::TIMER_POSITION,
            Table::TYPE_SMALLINT,
            null,
            [
                Table::OPTION_NULLABLE => false,
                Table::OPTION_UNSIGNED => true
            ],
            'Countdown Timer position'
        );
        $table->addIndex(
            $setup->getIdxName(
                $tableName,
                [StockstatusTimerInformationInterface::STOCKSTATUS_RULE_ID],
                AdapterInterface::INDEX_TYPE_UNIQUE
            ),
            [StockstatusTimerInformationInterface::STOCKSTATUS_RULE_ID],
            [Table::OPTION_TYPE => AdapterInterface::INDEX_TYPE_UNIQUE]
        );
        $table->addIndex(
            $setup->getIdxName(
                $tableName,
                [StockstatusTimerInformationInterface::STOCKSTATUS_RULE_ID],
                AdapterInterface::INDEX_TYPE_UNIQUE
            ),
            [StockstatusTimerInformationInterface::STOCKSTATUS_RULE_ID],
            [Table::OPTION_TYPE => AdapterInterface::INDEX_TYPE_UNIQUE]
        );
        $table->addForeignKey(
            $setup->getFkName(
                $tableName,
                StockstatusTimerInformationInterface::STOCKSTATUS_RULE_ID,
                $setup->getTable(RuleInterface::MAIN_TABLE),
                RuleInterface::ID
            ),
            StockstatusTimerInformationInterface::STOCKSTATUS_RULE_ID,
            $setup->getTable(RuleInterface::MAIN_TABLE),
            RuleInterface::ID,
            Table::ACTION_CASCADE
        );
        $table->addForeignKey(
            $setup->getFkName(
                $tableName,
                StockstatusTimerInformationInterface::TIMER_ID,
                $setup->getTable('widget_instance'),
                'instance_id'
            ),
            StockstatusTimerInformationInterface::TIMER_ID,
            $setup->getTable('widget_instance'),
            'instance_id'
        );

        $connection->createTable($table);
    }
}
