<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Setup;

use Amasty\CustomStockStatusTimer\Setup\Operation\CreateStockstatusTimerTable;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class InstallSchema implements InstallSchemaInterface
{
    /**
     * @var CreateStockstatusTimerTable
     */
    private $createStockstatusTimerTable;

    public function __construct(
        CreateStockstatusTimerTable $createStockstatusTimerTable
    ) {
        $this->createStockstatusTimerTable = $createStockstatusTimerTable;
    }

    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $this->createStockstatusTimerTable->execute($setup);
        $setup->endSetup();
    }
}
