<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Plugin\Stockstatus\RuleRepository;

use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetByStockstatusRuleIdInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetNewInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\SaveInterface;
use Amasty\Stockstatus\Api\Data\RuleInterface;
use Amasty\Stockstatus\Api\RuleRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;

class HandleDuplicateRule
{
    /**
     * @var GetNewInterface
     */
    private $getNew;

    /**
     * @var GetByStockstatusRuleIdInterface
     */
    private $getByStockstatusRuleId;

    /**
     * @var SaveInterface
     */
    private $save;

    public function __construct(
        GetNewInterface $getNew,
        GetByStockstatusRuleIdInterface $getByStockstatusRuleId,
        SaveInterface $save
    ) {
        $this->getNew = $getNew;
        $this->getByStockstatusRuleId = $getByStockstatusRuleId;
        $this->save = $save;
    }

    public function afterDuplicate(
        RuleRepositoryInterface $subject,
        RuleInterface $duplicatedModel,
        RuleInterface $modelForDuplicate
    ): RuleInterface {
        try {
            $stockstatusTimerToDuplicate = $this->getByStockstatusRuleId->execute((int)$modelForDuplicate->getId());
            $newStockstatusTimer = $this->getNew->execute();
            $newStockstatusTimer->setStockstatusRuleId((int)$duplicatedModel->getId());
            $newStockstatusTimer->setTimerPosition($stockstatusTimerToDuplicate->getTimerPosition());
            $newStockstatusTimer->setTimerId($stockstatusTimerToDuplicate->getTimerId());
            $this->save->execute($newStockstatusTimer);
        } catch (NoSuchEntityException $e) {
            null; //no action required
        }

        return $duplicatedModel;
    }
}
