<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model\StockstatusTimerInformation;

use Amasty\CustomStockStatusTimer\Api\Data\StockstatusTimerInformationInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetNewInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\SaveInterface;
use Amasty\CustomStockStatusTimer\Model\ResourceModel\StockstatusTimerInformation as TimerInformationResource;
use Magento\Framework\Exception\CouldNotSaveException;

class Save implements SaveInterface
{
    /**
     * @var GetNewInterface
     */
    private $getNew;

    /**
     * @var TimerInformationResource
     */
    private $stockstatusTimerInformationResource;

    public function __construct(
        TimerInformationResource $stockstatusTimerInformationResource,
        GetNewInterface $getNew
    ) {
        $this->getNew = $getNew;
        $this->stockstatusTimerInformationResource = $stockstatusTimerInformationResource;
    }

    public function execute(StockstatusTimerInformationInterface $stockstatusTimerInformation): void
    {
        try {
            if ($stockstatusTimerInformation->getId()) {
                $stockstatusTimerInformation = $this->loadById($stockstatusTimerInformation->getId())
                    ->addData($stockstatusTimerInformation->getData());
            }

            $this->stockstatusTimerInformationResource->save($stockstatusTimerInformation);
        } catch (\Exception $e) {
            if ($stockstatusTimerInformation->getId()) {
                throw new CouldNotSaveException(
                    __(
                        'Unable to save stockstatus timer info with ID %1. Error: %2',
                        [$stockstatusTimerInformation->getId(), $e->getMessage()]
                    )
                );
            }
            throw new CouldNotSaveException(
                __(
                    'Unable to save new stockstatus timer info. Error: %1',
                    $e->getMessage()
                )
            );
        }
    }

    private function loadById(int $id): StockstatusTimerInformationInterface
    {
        $model = $this->getNew->execute();
        $this->stockstatusTimerInformationResource->load($model, $id);

        return $model;
    }
}
