<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model\StockstatusTimerInformation;

use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetByStockstatusRuleIdInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\RemoveByStockstatusRuleIdInterface;
use Amasty\CustomStockStatusTimer\Model\ResourceModel\StockstatusTimerInformation as StatusTimerInformationResource;
use Magento\Framework\Exception\NoSuchEntityException;

class RemoveByStockstatusRuleId implements RemoveByStockstatusRuleIdInterface
{
    /**
     * @var GetByStockstatusRuleIdInterface
     */
    private $getByStockstatusRuleId;

    /**
     * @var StatusTimerInformationResource
     */
    private $statusTimerInformationResource;

    public function __construct(
        GetByStockstatusRuleIdInterface $getByStockstatusRuleId,
        StatusTimerInformationResource $statusTimerInformationResource
    ) {
        $this->getByStockstatusRuleId = $getByStockstatusRuleId;
        $this->statusTimerInformationResource = $statusTimerInformationResource;
    }

    public function execute(int $ruleId): void
    {
        try {
            $timerModel = $this->getByStockstatusRuleId->execute($ruleId);
            $this->statusTimerInformationResource->delete($timerModel);
        } catch (NoSuchEntityException $e) {
            null; //normal behavior. no action required
        }
    }
}
