<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model\StockstatusTimerInformation;

use Amasty\CustomStockStatusTimer\Api\Data\StockstatusTimerInformationInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetByStockstatusRuleIdInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetNewInterface;
use Magento\Framework\Exception\NoSuchEntityException;

class LoadByRuleIdOrGetNew
{
    /**
     * @var GetByStockstatusRuleIdInterface
     */
    private $getByStockstatusRuleId;

    /**
     * @var GetNewInterface
     */
    private $getNew;

    public function __construct(
        GetByStockstatusRuleIdInterface $getByStockstatusRuleId,
        GetNewInterface $getNew
    ) {
        $this->getByStockstatusRuleId = $getByStockstatusRuleId;
        $this->getNew = $getNew;
    }

    public function execute(int $ruleId): StockstatusTimerInformationInterface
    {
        try {
            $stockstatusTimerInfo = $this->getByStockstatusRuleId->execute($ruleId);
        } catch (NoSuchEntityException $e) {
            $stockstatusTimerInfo = $this->getNew->execute();
        }

        return $stockstatusTimerInfo;
    }
}
