<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model\StockstatusTimerInformation;

use Amasty\CustomStockStatusTimer\Api\Data\StockstatusTimerInformationInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetNewInterface;
use Amasty\CustomStockStatusTimer\Model\StockstatusTimerInformationFactory;

class GetNew implements GetNewInterface
{
    /**
     * @var StockstatusTimerInformationFactory
     */
    private $stockstatusTimerInformationFactory;

    public function __construct(
        StockstatusTimerInformationFactory $stockstatusTimerInformationFactory
    ) {
        $this->stockstatusTimerInformationFactory = $stockstatusTimerInformationFactory;
    }

    public function execute(): StockstatusTimerInformationInterface
    {
        return $this->stockstatusTimerInformationFactory->create();
    }
}
