<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model\StockstatusTimerInformation;

use Amasty\CustomStockStatusTimer\Api\Data\StockstatusTimerInformationInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetByStockstatusRuleIdInterface;
use Amasty\CustomStockStatusTimer\Api\StockstatusTimerInformation\GetNewInterface;
use Amasty\CustomStockStatusTimer\Model\ResourceModel\StockstatusTimerInformation;
use Magento\Framework\Exception\NoSuchEntityException;

class GetByStockstatusRuleId implements GetByStockstatusRuleIdInterface
{
    /**
     * @var StockstatusTimerInformationInterface[]
     */
    private $cache;

    /**
     * @var GetNewInterface
     */
    private $getNew;

    /**
     * @var StockstatusTimerInformation
     */
    private $stockstatusTimerInformationResource;

    public function __construct(
        GetNewInterface $getNew,
        StockstatusTimerInformation $stockstatusTimerInformationResource
    ) {
        $this->getNew = $getNew;
        $this->stockstatusTimerInformationResource = $stockstatusTimerInformationResource;
    }

    public function execute(int $ruleId): StockstatusTimerInformationInterface
    {
        if (!isset($this->cache[$ruleId])) {
            $model = $this->getNew->execute();
            $this->stockstatusTimerInformationResource->load(
                $model,
                $ruleId,
                StockstatusTimerInformationInterface::STOCKSTATUS_RULE_ID
            );

            if ($model->getId() === null) {
                throw new NoSuchEntityException(
                    __('Stockstatus Timer Information with specified rule id "%1" not found.', $ruleId)
                );
            }

            $this->cache[$ruleId] = $model;
        }

        return $this->cache[$ruleId];
    }
}
