<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model;

use Amasty\CustomStockStatusTimer\Api\Data\StockstatusTimerInformationInterface;
use Amasty\CustomStockStatusTimer\Model\ResourceModel\StockstatusTimerInformation as StockstatusTimerResource;
use Magento\Framework\Model\AbstractModel;

class StockstatusTimerInformation extends AbstractModel implements StockstatusTimerInformationInterface
{
    protected function _construct(): void
    {
        $this->_init(StockstatusTimerResource::class);
    }

    public function getId()
    {
        return $this->hasData(self::ID) ? (int)$this->_getData(self::ID) : null;
    }

    public function getStockstatusRuleId(): int
    {
        return (int)$this->_getData(self::STOCKSTATUS_RULE_ID);
    }

    public function setStockstatusRuleId(int $stockstatusRuleId): void
    {
        $this->setData(self::STOCKSTATUS_RULE_ID, $stockstatusRuleId);
    }

    public function getTimerId(): int
    {
        return (int)$this->_getData(self::TIMER_ID);
    }

    public function setTimerId(int $timerId): void
    {
        $this->setData(self::TIMER_ID, $timerId);
    }

    public function getTimerPosition(): int
    {
        return (int)$this->_getData(self::TIMER_POSITION);
    }

    public function setTimerPosition(int $timerPosition): void
    {
        $this->setData(self::TIMER_POSITION, $timerPosition);
    }
}
