<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;

class TimerPositions implements OptionSourceInterface
{
    public const POSITION_BEFORE_STOCKSTATUS = 1;
    public const POSITION_AFTER_STOCKSTATUS = 2;

    public function toOptionArray(): array
    {
        return [
            [
                'label' => __('After Custom Stock Status'),
                'value' => self::POSITION_AFTER_STOCKSTATUS
            ],
            [
                'label' => __('Before Custom Stock Status'),
                'value' => self::POSITION_BEFORE_STOCKSTATUS
            ]
        ];
    }
}
