<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model\Source;

use Amasty\PromoCountdown\Block\Widgets\Countdown;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Widget\Model\ResourceModel\Widget\Instance\Collection as TimersCollection;
use Magento\Widget\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\Widget\Model\Widget\Instance;

class CountdownTimers implements OptionSourceInterface
{
    public const UNSELECTED_VALUE = 0;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var array
     */
    private $options = [];

    public function __construct(
        CollectionFactory $collectionFactory
    ) {
        $this->collectionFactory = $collectionFactory;
    }

    public function toOptionArray(): array
    {
        if (empty($this->options)) {
            $options = array_map(function (Instance $timer): array {
                return [
                    'value' => $timer->getId(),
                    'label' => $timer->getTitle()
                ];
            }, $this->getTimersCollection()->getItems());
            array_unshift($options, ['label' => __('Please Select'), 'value' => self::UNSELECTED_VALUE]);
            $this->options = $options;
        }

        return $this->options;
    }

    public function getTimersCollection(): TimersCollection
    {
        /** @var TimersCollection $collection **/
        $collection = $this->collectionFactory->create();
        $collection->addFieldToFilter('instance_type', Countdown::class);

        return $collection;
    }
}
