<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Model\CountdownTimer;

use Amasty\PromoCountdown\Block\Widgets\Countdown;
use Magento\Framework\View\Element\BlockInterface;
use Magento\Framework\View\LayoutInterface;
use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Widget\Model\ResourceModel\Widget\Instance as WidgetResource;
use Magento\Widget\Model\Widget\Instance as CountdownWidget;
use Magento\Widget\Model\Widget\InstanceFactory;

class GetCountdownBlockByWidgetId
{
    /**
     * @var WidgetResource
     */
    private $widgetResource;

    /**
     * @var InstanceFactory
     */
    private $instanceFactory;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var LayoutInterface
     */
    private $layout;

    public function __construct(
        WidgetResource $widgetResource,
        InstanceFactory $instanceFactory,
        StoreManagerInterface $storeManager,
        LayoutInterface $layout
    ) {
        $this->widgetResource = $widgetResource;
        $this->instanceFactory = $instanceFactory;
        $this->storeManager = $storeManager;
        $this->layout = $layout;
    }

    public function execute(int $id): ?Countdown
    {
        $result = null;
        $countdownWidget = $this->instanceFactory->create();
        $this->widgetResource->load($countdownWidget, $id);

        if ($countdownWidget->getId()
            && $this->isCurrentWidgetAllowedForCurrentStore($countdownWidget)
        ) {
            /** @var Countdown $result * */
            $result = $this->getTimerBlock();
            $result->setData($countdownWidget->getWidgetParameters());
        }

        return $result;
    }

    private function isCurrentWidgetAllowedForCurrentStore(CountdownWidget $countdownWidget): bool
    {
        $widgetStores = $countdownWidget->getStoreIds();

        return in_array($this->storeManager->getStore()->getId(), $widgetStores)
            || in_array(Store::DEFAULT_STORE_ID, $widgetStores);
    }

    private function getTimerBlock(): BlockInterface
    {
        return $this->layout->createBlock(Countdown::class);
    }
}
