<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Custom Stock Status Countdown for Magento 2 (System)
*/

declare(strict_types=1);

namespace Amasty\CustomStockStatusTimer\Api\Data;

/**
 * @api
 */
interface StockstatusTimerInformationInterface
{
    public const MAIN_TABLE = 'amasty_stockstatus_timer_data';

    public const ID = 'id';
    public const STOCKSTATUS_RULE_ID = 'stockstatus_rule_id';
    public const TIMER_ID = 'timer_id';
    public const TIMER_POSITION = 'timer_position';

    /**
     * @return int|null
     */
    public function getId();

    /**
     * @param int $id
     */
    public function setId($id);

    /**
     * @return int
     */
    public function getStockstatusRuleId(): int;

    /**
     * @param int $stockstatusRuleId
     */
    public function setStockstatusRuleId(int $stockstatusRuleId): void;

    /**
     * @return int
     */
    public function getTimerId(): int;

    /**
     * @param int $timerId
     */
    public function setTimerId(int $timerId): void;

    /**
     * @return int
     */
    public function getTimerPosition(): int;

    /**
     * @param int $timerPosition
     */
    public function setTimerPosition(int $timerPosition): void;
}
