<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Form Compatibility with Hyva Theme
 */

namespace Amasty\CustomFormHyva\Plugin\Customform\Block\Form;

use Amasty\Customform\Block\Form as FormBlock;
use Amasty\CustomFormHyva\Model\IsHyvaEnabled;

class ChangeTemplate
{
    /**
     * @var IsHyvaEnabled
     */
    private $isHyvaEnabled;

    public function __construct(IsHyvaEnabled $isHyvaEnabled)
    {
        $this->isHyvaEnabled = $isHyvaEnabled;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetTemplate(FormBlock $subject, string $result): string
    {
        if ($this->isHyvaEnabled->execute()) {
            return 'Amasty_CustomFormHyva::init.phtml';
        }

        return $result;
    }
}
