<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Form Compatibility with Hyva Theme
 */

namespace Amasty\CustomFormHyva\Model;

use Magento\Framework\View\DesignInterface;

class IsHyvaEnabled
{
    private const THEME_FOLDER = 'Hyva/';

    /**
     * @var DesignInterface
     */
    private $design;

    public function __construct(DesignInterface $design)
    {
        $this->design = $design;
    }

    /**
     * Check is hyva enabled on current store.
     */
    public function execute(): bool
    {
        $theme = $this->design->getDesignTheme();
        while ($theme) {
            if (strpos($theme->getCode(), self::THEME_FOLDER) === 0) {
                return true;
            }
            $theme = $theme->getParentTheme();
        }

        return false;
    }
}
