<?php

declare(strict_types=1);

namespace Amasty\CustomButton\Model\Config\Source;

class Style implements \Magento\Framework\Data\OptionSourceInterface
{
    public const BUTTON_PATH = 'color_scheme/';

    public const PRIMARY = 'primary';

    public const SECONDARY = 'secondary';

    public const CUSTOM = 'custom';

    public function toOptionArray(): array
    {
        return [
            ['value' => self::PRIMARY, 'label' => __('Primary')],
            ['value' => self::SECONDARY, 'label' => __('Secondary')],
            ['value' => self::CUSTOM, 'label' => __('Custom')]
        ];
    }
}
