<?php

declare(strict_types=1);

namespace Amasty\CustomButton\Model\Config\Source;

class HideOn implements \Magento\Framework\Data\OptionSourceInterface
{
    public const DESKTOP = '-no-desktop';

    public const MOBILE = '-no-mobile';

    public const TABLET = '-no-tablet';

    public function toOptionArray(): array
    {
        return [
            ['value' => self::DESKTOP, 'label' => __('Desktop')],
            ['value' => self::TABLET, 'label' => __('Tablet')],
            ['value' => self::MOBILE, 'label' => __('Mobile')]
        ];
    }
}
