<?php

declare(strict_types=1);

namespace Amasty\CustomButton\Model\Config\Source;

class ButtonAlignment implements \Magento\Framework\Data\OptionSourceInterface
{
    public const CENTER = 'center';

    public const LEFT = 'left';

    public const RIGHT = 'right';

    public function toOptionArray(): array
    {
        return [
            ['value' => self::CENTER, 'label' => __('Center')],
            ['value' => self::LEFT, 'label' => __('Left')],
            ['value' => self::RIGHT, 'label' => __('Right')]
        ];
    }
}
