<?php

declare(strict_types=1);

namespace Amasty\CustomButton\Model\Config\Source;

class Animation implements \Magento\Framework\Data\OptionSourceInterface
{
    public const NONE = 0;

    public const CIRCLE = 'circle';

    public const POSITION = 'position-aware';

    public const COLLISION = 'collision';

    public const BORDER_RACE = 'border-race';

    public function toOptionArray(): array
    {
        return [
            ['value' => self::NONE, 'label' => __('None')],
            ['value' => self::CIRCLE, 'label' => __('Circle Overlap')],
            ['value' => self::POSITION, 'label' => __('Position Aware')],
            ['value' => self::COLLISION, 'label' => __('Collision')],
            ['value' => self::BORDER_RACE, 'label' => __('Border Race')]
        ];
    }
}
