<?php

declare(strict_types=1);

namespace Amasty\CustomButton\Block;

use Magento\Framework\View\Element\Template;
use Magento\Widget\Block\BlockInterface;

class Wrapper extends Template implements BlockInterface
{
    /**
     * @var \Magento\Framework\Module\Manager
     */
    private $moduleManager;

    public function __construct(
        \Magento\Framework\Module\Manager $moduleManager,
        \Magento\Framework\View\Element\Template\Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->moduleManager = $moduleManager;
    }

    /**
     * @return string
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function toHtml(): string
    {
        if ($this->moduleManager->isEnabled('Amasty_CustomButton')) {
            $widget = $this->getLayout()->createBlock(
                CustomButton::class
            )->setData(
                $this->getData()
            );

            $html = $widget->toHtml();
        }

        return $html ?? '';
    }
}
