<?php

declare(strict_types=1);

namespace Amasty\CustomButton\Block;

use Amasty\CustomButton\Model\Config\Source\Style;
use Amasty\CustomButton\Model\ConfigProvider;
use Magento\Framework\App\Http\Context as HttpContext;
use Magento\Framework\View\Element\Template;

class CustomButton extends Template
{
    protected $_template = 'Amasty_CustomButton::widget/button.phtml';

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var HttpContext
     */
    private $httpContext;

    public function __construct(
        Template\Context $context,
        ConfigProvider $configProvider,
        HttpContext $httpContext,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->configProvider = $configProvider;
        $this->httpContext = $httpContext;
    }

    public function getCssPropertyIfExist(string $property, string $value): string
    {
        if ($value) {
            $result = sprintf('%s: %s;', $property, $value);
        }

        return $result ?? '';
    }

    public function toHtml()
    {
        if ($this->validate()) {
            return parent::toHtml();
        }

        return '';
    }

    private function validate(): bool
    {
        $result = true;
        $hideForGroups = (string)$this->getData('customer_groups');
        if ($hideForGroups !== "") {
            $groups = explode(',', $hideForGroups);
            $current = $this->httpContext->getValue(\Magento\Customer\Model\Context::CONTEXT_GROUP);
            $result = $result && !in_array($current, $groups);
        }

        return $result;
    }

    public function getColor(string $type): string
    {
        switch ($this->getData('style')) {
            case Style::PRIMARY:
                $color = $this->configProvider->getConfigValue(Style::BUTTON_PATH . Style::PRIMARY . '/' . $type);
                break;
            case Style::SECONDARY:
                $color = $this->configProvider->getConfigValue(Style::BUTTON_PATH . Style::SECONDARY . '/' . $type);
                break;
            case Style::CUSTOM:
                $color = $this->getData($type);
                break;
        }

        return $color ?? '';
    }
}
