<?php

declare(strict_types=1);

namespace Amasty\CustomButton\Block\Adminhtml\Widget;

use Amasty\CustomButton\Block\Adminhtml\Widget\Form\Element\TextFactory;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Framework\Data\Form\Element\AbstractElement;

class Validation extends Extended
{
    /**
     * @var TextFactory
     */
    private $textFactory;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Backend\Helper\Data $backendHelper,
        TextFactory $textFactory,
        array $data = []
    ) {
        parent::__construct($context, $backendHelper, $data);
        $this->textFactory = $textFactory;
    }

    /**
     * @param AbstractElement $element Form Element
     * @return AbstractElement
     */
    public function prepareElementHtml(AbstractElement $element)
    {
        if ($element->getValue() === "") {
            $element->setData('value', $this->getData('value'));
        }
        $newElement = $this->textFactory->create()->setData($element->getData());
        $newElement->setForm($element->getForm())
            ->addClass($this->getData('validation'));
        $element->setData('after_element_html', $newElement->getHtml())
            ->setValue('')
            ->setNote($this->getData('description'));

        return $element;
    }
}
