<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Multiple Coupons Hyva Theme
 */

namespace Amasty\CouponsHyva\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\UrlInterface;
use Magento\Store\Api\Data\StoreInterface;

class Coupons implements ArgumentInterface
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var UrlInterface
     */
    private $url;

    /**
     * @var StoreInterface|null
     */
    private $store = null;

    public function __construct(
        StoreManagerInterface $storeManager,
        UrlInterface $url
    ) {
        $this->storeManager = $storeManager;
        $this->url = $url;
    }

    public function getGuestAddCouponUrl(): string
    {
        $storeCode = $this->getStore()->getCode();
        return $this->url->getUrl("rest/$storeCode/V1/guest-carts/:cartId/multicoupons/apply-to-cart");
    }

    public function getCustomerAddCouponUrl(): string
    {
        $storeCode = $this->getStore()->getCode();
        return $this->url->getUrl("rest/$storeCode/V1/carts/mine/multicoupons/apply-to-cart");
    }

    public function getStore()
    {
        if ($this->store === null) {
            $this->store = $this->storeManager->getStore();
        }

        return $this->store;
    }
}
