<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package B2B Company Account for Magento 2
 */

namespace Amasty\CompanyAccount\Controller\Adminhtml\Company;

use Magento\Framework\Data\Collection\AbstractDb;
use Amasty\CompanyAccount\Model\Source\Company\Status;

class MassDisable extends \Amasty\CompanyAccount\Controller\Adminhtml\Company\MassActionAbstract
{
    /**
     * @param AbstractDb $collection
     */
    public function doAction(AbstractDb $collection)
    {
        $collectionSize = $collection->getSize();
        foreach ($collection as $company) {
            /**
             * @TODO be shure, that all customer of company will be blocked
             */
            $company->setStatus(Status::STATUS_INACTIVE);
            $this->companyRepository->save($company);
        }
        $this->messageManager->addSuccessMessage(__('A total of %1 record(s) have been deactivated.', $collectionSize));
    }
}
