<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Common Tests MFTF 3 for Magento 2 (System)
 */

namespace Amasty\CommonTestsMFTF3\Test\Mftf\Helper;

use Codeception\Exception\ModuleException;
use Magento\FunctionalTestingFramework\Helper\Helper;
use Magento\FunctionalTestingFramework\Module\MagentoWebDriver;

class AmastyConfigHelper extends Helper
{
    /** Create Entity
     *
     * @param string $settingPath   Path to setting
     * @param string $settingValue  Value for sett to setting
     *
     * @return void
     * @throws ModuleException
     */
    public function amastySetConfig(
        string $settingPath,
        string $settingValue
    ): void
    {
        /** @var MagentoWebDriver $webDriver */
        $magentoWebDriver = $this->getModule('\Magento\FunctionalTestingFramework\Module\MagentoWebDriver');

        try {
            $command = "config:set " . $settingPath . ' ' . $settingValue;
            $magentoWebDriver->magentoCLI($command);
        } catch (\Exception $e) {
            printf(PHP_EOL . 'Config path is not exist!' . PHP_EOL);
        }
    }
}
