<?php
declare(strict_types=1);

namespace Amasty\CmsImportEntity\Import\Validation\RelationValidator;

use Amasty\CmsImportEntity\Model\ResourceModel\Store\RelationUniqueness;
use Amasty\ImportCore\Api\Validation\RelationValidatorInterface;
use Magento\Cms\Api\Data\BlockInterface;

class BlockStoreValidator implements RelationValidatorInterface
{
    /**
     * @var RelationUniqueness
     */
    private $relationUniqueness;

    /**
     * @var string|null
     */
    private $message;

    public function __construct(
        RelationUniqueness $relationUniqueness
    ) {
        $this->relationUniqueness = $relationUniqueness;
    }

    /**
     * @inheritDoc
     */
    public function validate(array $entityRow, array $subEntityRows): bool
    {
        if (isset($entityRow['identifier'])) {
            $storeIds = array_column($subEntityRows, 'store_id');
            if (!$this->relationUniqueness->isIdentifierUnique(
                BlockInterface::class,
                $entityRow['identifier'],
                $storeIds
            )) {
                $this->message = (string)__(
                    'A block identifier %1 already exists in the specified stores: %2.',
                    $entityRow['identifier'],
                    implode(',', $storeIds)
                );

                return false;
            }
        }

        return true;
    }

    /**
     * @inheritDoc
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }
}
