<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package One Step Checkout Trust Badges by Amasty
 */

namespace Amasty\CheckoutTrustBadges\Setup\Patch\Data;

use Magento\Cms\Api\Data\BlockInterfaceFactory;
use Magento\Cms\Model\Block;
use Magento\Cms\Model\BlockFactory;
use Magento\Cms\Model\BlockRepository;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Store\Model\Store;

class AddTrustSealsSampleBlock implements DataPatchInterface
{
    /**
     * @var BlockFactory
     */
    private $blockFactory;

    /**
     * @var BlockRepository
     */
    private $blockRepository;

    public function __construct(
        BlockInterfaceFactory $blockFactory,
        BlockRepository $blockRepository
    ) {
        $this->blockFactory = $blockFactory;
        $this->blockRepository = $blockRepository;
    }

    public static function getDependencies(): array
    {
        return [];
    }

    public function getAliases(): array
    {
        return [];
    }

    public function apply()
    {
        $block = $this->blockFactory->create();
        $blockContent = '<div class="amcheckout-trust-seal">'
            . '<p class="amcheckout-title">Guaranted <b>Safe & Secure</b> Checkout</p>'
            . '<img src="{{view url=Amasty_CheckoutTrustBadges::img/trust_seals_sample.png}}"> '
            . '<p class="amcheckout-description">This is a demonstration of trust badge.</p>'
            . '</div>';

        $block
            ->setIdentifier('trust_seals_block')
            ->setIsActive(Block::STATUS_ENABLED)
            ->setTitle('Trust Seals Block')
            ->setContent($blockContent)
            ->setStores([Store::DEFAULT_STORE_ID]);

        $this->blockRepository->save($block);

        return $this;
    }
}
