<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package One Step Checkout Trust Badges by Amasty
 */

namespace Amasty\CheckoutTrustBadges\Block\Onepage\LayoutProcessor;

use Amasty\CheckoutCore\Block\Onepage\CustomBlock\BlockFactory;
use Amasty\CheckoutCore\Block\Onepage\LayoutWalkerFactory;
use Amasty\CheckoutCore\Model\Config;
use Amasty\CheckoutStyleSwitcher\Model\ConfigProvider as StyleSwitcherConfig;
use Magento\Checkout\Block\Checkout\LayoutProcessorInterface;

class TrustSealsProcessor implements LayoutProcessorInterface
{
    private const SUMMARY_PATH = '{SIDEBAR}.>>.trust-seals';
    private const PAYMENT_PATH = '{PAYMENT}.>>.afterMethods.>>.trustSeals';

    /**
     * @var LayoutWalkerFactory
     */
    private $walkerFactory;

    /**
     * @var Config
     */
    private $checkoutConfig;

    /**
     * @var BlockFactory
     */
    private $blockFactory;

    /**
     * @var StyleSwitcherConfig
     */
    private $styleSwitcherConfig;

    public function __construct(
        Config $checkoutConfig,
        StyleSwitcherConfig $styleSwitcherConfig,
        LayoutWalkerFactory $walkerFactory,
        BlockFactory $blockFactory
    ) {
        $this->checkoutConfig = $checkoutConfig;
        $this->styleSwitcherConfig = $styleSwitcherConfig;
        $this->walkerFactory = $walkerFactory;
        $this->blockFactory = $blockFactory;
    }
    
    public function process($jsLayout)
    {
        if (!$this->checkoutConfig->isEnabled()) {
            return $jsLayout;
        }

        if (!$this->checkoutConfig->getCustomBlockIdByPosition('trust_seals_')) {
            return $jsLayout;
        }

        if ($this->styleSwitcherConfig->getPlaceOrderPosition() === 'summary') {
            return $this->addBlock(self::SUMMARY_PATH, $jsLayout);
        }

        return $this->addBlock(self::PAYMENT_PATH, $jsLayout);
    }

    public function addBlock(string $path, array $jsLayout): array
    {
        $walker = $this->walkerFactory->create(['layoutArray' => $jsLayout]);
        $customBlock = $this->blockFactory->create();
        $customBlock->setPosition('trust_seals');
        $customBlock->setNameInLayout('amasty_checkout_trust_seals');
        $blockHtml = $customBlock->toHtml();
        $trustSealConfig = [
            'component' => 'uiComponent',
            'value' => $blockHtml,
            'template' => 'Amasty_CheckoutTrustBadges/trust-seals',
            'sortOrder' => 1
        ];

        $walker->setValue($path, $trustSealConfig);

        return $walker->getResult();
    }
}
